import { useState } from "react";
import { MaterialSelection } from "@/components/wizard/material-selection";
import { VolumeCalculator } from "@/components/wizard/volume-calculator";
import { ServiceSelection } from "@/components/wizard/service-selection";
import { LocationTimeline } from "@/components/wizard/location-timeline";
import { ContactInfo } from "@/components/wizard/contact-info";
import { QuoteDisplay } from "@/components/wizard/quote-display";
import { ProgressIndicator } from "@/components/wizard/progress-indicator";
import { useWizard } from "@/hooks/use-wizard";
import { Leaf, Shield, Award } from "lucide-react";

export default function Widget() {
  const { currentStep, wizardData, goToStep, updateData, submitLead } = useWizard();

  const steps = [
    { component: MaterialSelection, title: "Material Type" },
    { component: VolumeCalculator, title: "Volume" },
    { component: ServiceSelection, title: "Service" },
    { component: LocationTimeline, title: "Location" },
    { component: ContactInfo, title: "Contact" },
    { component: QuoteDisplay, title: "Quote" },
  ];

  const CurrentStepComponent = steps[currentStep - 1].component;

  return (
    <div className="min-h-screen bg-eco-bg p-4">
      <div className="max-w-4xl mx-auto">
        {/* Widget Header */}
        <div className="bg-white rounded-t-xl shadow-lg border border-green-200">
          <div className="p-6 border-b border-green-100">
            <div className="flex items-center justify-between">
              <div className="flex items-center space-x-3">
                <div className="w-10 h-10 bg-eco-primary rounded-lg flex items-center justify-center">
                  <Leaf className="text-white text-lg" />
                </div>
                <div>
                  <h1 className="text-2xl font-bold text-eco-secondary">Green Tech Shredding</h1>
                  <p className="text-sm text-gray-600">Secure Document Destruction</p>
                </div>
              </div>
              <div className="hidden md:flex items-center space-x-4">
                <div className="flex items-center text-sm text-gray-600">
                  <Shield className="text-eco-primary mr-2 w-4 h-4" />
                  HIPAA Compliant
                </div>
                <div className="flex items-center text-sm text-gray-600">
                  <Award className="text-eco-primary mr-2 w-4 h-4" />
                  Certified Destruction
                </div>
              </div>
            </div>
          </div>

          <ProgressIndicator 
            currentStep={currentStep} 
            totalSteps={6}
            steps={["Material", "Volume", "Service", "Location", "Contact", "Quote"]}
          />
        </div>

        {/* Wizard Content */}
        <div className="bg-white shadow-lg border-x border-green-200 min-h-[600px]">
          {currentStep === 1 && (
            <MaterialSelection 
              data={wizardData}
              onUpdate={updateData}
              onNext={() => goToStep(currentStep + 1)}
            />
          )}
          {currentStep === 2 && (
            <VolumeCalculator 
              data={wizardData}
              onUpdate={updateData}
              onNext={() => goToStep(currentStep + 1)}
              onBack={() => goToStep(currentStep - 1)}
            />
          )}
          {currentStep === 3 && (
            <ServiceSelection 
              data={wizardData}
              onUpdate={updateData}
              onNext={() => goToStep(currentStep + 1)}
              onBack={() => goToStep(currentStep - 1)}
            />
          )}
          {currentStep === 4 && (
            <LocationTimeline 
              data={wizardData}
              onUpdate={updateData}
              onNext={() => goToStep(currentStep + 1)}
              onBack={() => goToStep(currentStep - 1)}
            />
          )}
          {currentStep === 5 && (
            <ContactInfo 
              data={wizardData}
              onUpdate={updateData}
              onNext={() => goToStep(currentStep + 1)}
              onBack={() => goToStep(currentStep - 1)}
              onSubmit={submitLead}
            />
          )}
          {currentStep === 6 && (
            <QuoteDisplay 
              data={wizardData}
              onBack={() => goToStep(currentStep - 1)}
            />
          )}
        </div>

        {/* Widget Footer */}
        <div className="bg-white rounded-b-xl shadow-lg border border-green-200 border-t-0">
          <div className="p-4 bg-gray-50 text-center text-sm text-gray-600">
            <div className="flex items-center justify-center space-x-4">
              <div className="flex items-center">
                <span className="text-eco-primary mr-1">📞</span>
                <span>Need help? Call (800) 555-SHRED</span>
              </div>
              <div className="hidden md:flex items-center">
                <span className="text-eco-primary mr-1">🕒</span>
                <span>Available 24/7</span>
              </div>
            </div>
            <div className="mt-2 text-xs">
              Powered by Green Tech Shredding | 
              <a href="#" className="text-eco-primary hover:underline ml-1">Privacy Policy</a> | 
              <a href="#" className="text-eco-primary hover:underline ml-1">Terms of Service</a>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
}
