export interface VolumeData {
  fileBoxes: number;
  filingCabinets: number;
  bags: number;
  pallets: number;
}

export interface WizardData {
  // Step 1: Material Types
  materialTypes: string[];
  
  // Step 2: Volume
  volumeData: VolumeData;
  
  // Step 3: Service Type
  serviceType: string;
  
  // Step 4: Location & Timeline
  zipCode: string;
  timeline: string;
  specialRequirements: string[];
  
  // Step 5: Contact Info
  name: string;
  email: string;
  phone: string;
  company: string;
  preferredContact: string;
}

export interface QuoteResult {
  totalBoxes: number;
  totalWeight: number;
  price: number;
  savings: number;
  serviceType: string;
}
